/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.enhancedcelestials.EnhancedCelestials;
import corgitaco.enhancedcelestials.LunarEventInstance;
import corgitaco.enhancedcelestials.LunarForecast;
import corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.api.lunarevent.LunarTextComponents;
import corgitaco.enhancedcelestials.lunarevent.Moon;
import corgitaco.enhancedcelestials.network.LunarEventChangedPacket;
import corgitaco.enhancedcelestials.network.LunarForecastChangedPacket;
import corgitaco.enhancedcelestials.platform.Services;
import corgitaco.enhancedcelestials.save.LunarEventSavedData;
import it.unimi.dsi.fastutil.objects.Object2LongArrayMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import org.apache.logging.log4j.Logger;

public class LunarContext {
    public static final String CONFIG_NAME = "lunar-settings.json";
    private static final LunarEvent DEFAULT = Moon.MOON;
    public static final Codec<LunarContext> PACKET_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)LunarForecast.CODEC.fieldOf("lunarForecast").forGetter(lunarContext -> lunarContext.lunarForecast), (App)LunarTimeSettings.CODEC.fieldOf("lunarTimeSettings").forGetter(lunarContext -> lunarContext.lunarTimeSettings), (App)class_2960.field_25139.fieldOf("worldID").forGetter(lunarEventContext -> lunarEventContext.worldID), (App)Codec.unboundedMap((Codec)Codec.STRING, LunarEvent.CODEC).fieldOf("lunarEvents").forGetter(lunarEventContext -> lunarEventContext.lunarEvents)).apply((Applicative)builder, LunarContext::new));
    private final Map<String, LunarEvent> lunarEvents = new HashMap<String, LunarEvent>();
    private final LunarForecast lunarForecast;
    private final class_2960 worldID;
    private final Path lunarConfigPath;
    private final Path lunarEventsConfigPath;
    private final LunarTimeSettings lunarTimeSettings;
    private final long dayLength;
    private final long yearLengthInDays;
    private final long minDaysBetweenEvents;
    private final ArrayList<String> scrambledKeys = new ArrayList();
    private LunarEvent currentEvent;
    private LunarEvent lastEvent;
    private float strength;

    public LunarContext(class_3218 world) {
        LunarEventInstance nextLunarEvent;
        this.worldID = world.method_27983().method_29177();
        this.lunarConfigPath = EnhancedCelestials.CONFIG_PATH.resolve(this.worldID.method_12836()).resolve(this.worldID.method_12832()).resolve("lunar");
        this.lunarEventsConfigPath = this.lunarConfigPath.resolve("events");
        this.lunarTimeSettings = LunarContext.readOrCreateConfigJson(this.lunarConfigPath.resolve(CONFIG_NAME).toFile());
        this.dayLength = this.lunarTimeSettings.dayLength;
        this.yearLengthInDays = this.lunarTimeSettings.yearLength;
        this.minDaysBetweenEvents = this.lunarTimeSettings.minDaysBetweenLunarEvents;
        this.handleEventConfigs(false);
        this.scrambledKeys.addAll(this.lunarEvents.keySet());
        this.lunarForecast = this.getAndComputeLunarForecast(world).getForecast();
        assert (this.lunarForecast != null);
        LunarEventInstance lunarEventInstance = nextLunarEvent = this.lunarForecast.getForecast().isEmpty() ? null : this.lunarForecast.getForecast().get(0);
        this.currentEvent = nextLunarEvent == null ? DEFAULT : (nextLunarEvent.getDaysUntil((int)(world.method_8532() / this.dayLength)) <= 0L && world.method_23886() ? nextLunarEvent.getEvent(this.lunarEvents) : DEFAULT);
    }

    public LunarContext(LunarForecast lunarForecast, LunarTimeSettings lunarTimeSettings, class_2960 worldID, Map<String, LunarEvent> lunarEvents) {
        this(lunarForecast, lunarTimeSettings, worldID, lunarEvents, false);
    }

    public LunarContext(LunarForecast lunarForecast, LunarTimeSettings lunarTimeSettings, class_2960 worldID, Map<String, LunarEvent> lunarEvents, boolean serializeClientOnlyConfigs) {
        LunarEventInstance nextLunarEvent;
        this.worldID = worldID;
        this.lunarConfigPath = EnhancedCelestials.CONFIG_PATH.resolve(worldID.method_12836()).resolve(worldID.method_12832()).resolve("lunar");
        this.lunarEventsConfigPath = this.lunarConfigPath.resolve("events");
        this.lunarEvents.putAll(lunarEvents);
        LunarEventInstance lunarEventInstance = nextLunarEvent = lunarForecast.getForecast().isEmpty() ? null : lunarForecast.getForecast().get(0);
        this.currentEvent = nextLunarEvent == null ? DEFAULT : (nextLunarEvent.scheduledDay() == 0L ? nextLunarEvent.getEvent(this.lunarEvents) : DEFAULT);
        this.lunarForecast = lunarForecast;
        this.lunarTimeSettings = lunarTimeSettings;
        this.dayLength = lunarTimeSettings.dayLength;
        this.yearLengthInDays = lunarTimeSettings.yearLength;
        this.minDaysBetweenEvents = lunarTimeSettings.minDaysBetweenLunarEvents;
        if (serializeClientOnlyConfigs) {
            this.handleEventConfigs(true);
        }
        this.lunarEvents.forEach((key, event) -> event.setKey((String)key));
    }

    public LunarEventSavedData getAndComputeLunarForecast(class_3218 world) {
        LunarEventSavedData lunarEventSavedData = LunarEventSavedData.get((class_1936)world);
        if (lunarEventSavedData.getForecast() == null) {
            lunarEventSavedData.setForecast(this.computeLunarForecast(world, new LunarForecast(new ArrayList<LunarEventInstance>(), world.method_8532())));
        }
        lunarEventSavedData.getForecast().getForecast().removeIf(lunarEventInstance -> !this.lunarEvents.containsKey(lunarEventInstance.getLunarEventKey()));
        lunarEventSavedData.setForecast(lunarEventSavedData.getForecast());
        return lunarEventSavedData;
    }

    public LunarForecast computeLunarForecast(class_3218 world, LunarForecast lunarForecast) {
        return this.computeLunarForecast(world, lunarForecast, 0L);
    }

    public LunarForecast computeLunarForecast(class_3218 world, LunarForecast lunarForecast, long seedModifier) {
        long currentDay;
        long dayTime = world.method_8532();
        long lastCheckedTime = lunarForecast.getLastCheckedGameTime();
        long lastCheckedDay = lastCheckedTime / this.dayLength;
        if (lastCheckedDay < (currentDay = dayTime / this.dayLength)) {
            lunarForecast.getForecast().clear();
            lunarForecast.setLastCheckedGameTime(currentDay * this.dayLength);
            lastCheckedTime = lunarForecast.getLastCheckedGameTime();
            lastCheckedDay = lastCheckedTime / this.dayLength;
        }
        if (currentDay + this.yearLengthInDays == lastCheckedDay) {
            return lunarForecast;
        }
        ArrayList<LunarEventInstance> newLunarEvents = new ArrayList<LunarEventInstance>();
        Object2LongArrayMap eventByLastTime = new Object2LongArrayMap();
        List<LunarEventInstance> forecast = lunarForecast.getForecast();
        long lastDay = !forecast.isEmpty() ? forecast.get(forecast.size() - 1).scheduledDay() : currentDay;
        long day = lastCheckedDay;
        for (LunarEventInstance lunarEventInstance : forecast) {
            eventByLastTime.put((Object)lunarEventInstance.getEvent(this.lunarEvents), lunarEventInstance.scheduledDay());
        }
        while (day <= currentDay + this.yearLengthInDays) {
            dayTime += this.dayLength;
            Random random = new Random(world.method_8412() + (long)world.method_27983().method_29177().hashCode() + day + seedModifier);
            Collections.shuffle(this.scrambledKeys, random);
            for (String key : this.scrambledKeys) {
                LunarEvent value = this.lunarEvents.get(key);
                if (day - eventByLastTime.getOrDefault((Object)value, currentDay) <= (long)value.getMinNumberOfNightsBetween() || day - lastDay <= this.minDaysBetweenEvents || !(value.getChance() > random.nextDouble()) || !value.getValidMoonPhases().contains(world.method_8597().method_28531(dayTime - 1L))) continue;
                lastDay = day;
                newLunarEvents.add(new LunarEventInstance(key, day));
                eventByLastTime.put((Object)value, day);
            }
            ++day;
        }
        forecast.addAll(newLunarEvents);
        lunarForecast.setLastCheckedGameTime(day * this.dayLength);
        return lunarForecast;
    }

    public void tick(class_1937 world) {
        LunarEvent lastEvent = this.currentEvent;
        long currentDay = world.method_8532() / this.dayLength;
        if (!world.field_9236) {
            List players = ((class_3218)world).method_18456();
            this.updateForecast(world, currentDay, players);
            List<LunarEventInstance> forecast = this.getLunarForecast().getForecast();
            if (forecast.isEmpty()) {
                this.currentEvent = DEFAULT;
            } else {
                LunarEventInstance nextEvent = forecast.get(0);
                LunarEvent lunarEvent = this.currentEvent = nextEvent.getDaysUntil(currentDay) <= 0L && world.method_23886() ? nextEvent.getEvent(this.lunarEvents) : DEFAULT;
            }
            if (this.currentEvent != lastEvent) {
                LunarTextComponents.Notification startNotification;
                this.lastEvent = lastEvent;
                this.strength = 0.0f;
                LunarTextComponents.Notification endNotification = lastEvent.endNotification();
                if (endNotification != null) {
                    for (class_3222 player : players) {
                        player.method_7353((class_2561)endNotification.getCustomTranslationTextComponent(), endNotification.getNotificationType() == LunarTextComponents.NotificationType.HOT_BAR);
                    }
                }
                if ((startNotification = this.currentEvent.startNotification()) != null) {
                    for (class_3222 player : players) {
                        player.method_7353((class_2561)startNotification.getCustomTranslationTextComponent(), startNotification.getNotificationType() == LunarTextComponents.NotificationType.HOT_BAR);
                    }
                }
                Services.PLATFORM.sendToAllClients(players, new LunarEventChangedPacket(this.currentEvent.getKey()));
            }
        }
        this.strength = class_3532.method_15363((float)(this.strength + 0.01f), (float)0.0f, (float)1.0f);
    }

    private void updateForecast(class_1937 world, long currentDay, List<class_3222> players) {
        this.updateForecast(world, currentDay);
        long lastCheckedGameTime = this.lunarForecast.getLastCheckedGameTime();
        LunarForecast newLunarForecast = this.computeLunarForecast((class_3218)world, this.lunarForecast);
        long newLastCheckedGameTime = newLunarForecast.getLastCheckedGameTime();
        long newLastCheckedDay = newLastCheckedGameTime / this.dayLength;
        long lastCheckedDay = lastCheckedGameTime / this.dayLength;
        if (newLastCheckedDay != lastCheckedDay) {
            Services.PLATFORM.sendToAllClients(players, new LunarForecastChangedPacket(this.lunarForecast));
            LunarEventSavedData.get((class_1936)world).setForecast(this.lunarForecast);
        }
    }

    public void updateForecast(class_1937 world, long currentDay) {
        List<LunarEventInstance> forecast = this.lunarForecast.getForecast();
        if (forecast.isEmpty()) {
            return;
        }
        LunarEventInstance nextEvent = forecast.get(0);
        if (nextEvent.passed(currentDay)) {
            forecast.remove(0);
            Services.PLATFORM.sendToAllClients(((class_3218)world).method_18456(), new LunarForecastChangedPacket(this.lunarForecast));
            Services.PLATFORM.sendToAllClients(((class_3218)world).method_18456(), new LunarEventChangedPacket(this.currentEvent.getKey()));
            LunarEventSavedData.get((class_1936)world).setForecast(this.lunarForecast);
        }
    }

    public LunarEvent getCurrentEvent() {
        return this.currentEvent;
    }

    @Nullable
    public LunarEvent getLastEvent() {
        return this.lastEvent;
    }

    public void handleEventConfigs(boolean isClient) {
        File[] files;
        File eventsDirectory;
        if (isClient) {
            DEFAULT.setLunarEventClient(DEFAULT.getClientSettings().createClient(), "");
        }
        if (!(eventsDirectory = this.lunarEventsConfigPath.toFile()).exists()) {
            this.createDefaultEventConfigs();
        }
        if ((files = eventsDirectory.listFiles()).length == 0) {
            this.createDefaultEventConfigs();
        }
        if (isClient) {
            this.addSettingsIfMissing();
        }
        this.iterateAndReadConfiguredEvents(files, isClient);
    }

    private void iterateAndReadConfiguredEvents(File[] files, boolean isClient) {
        for (File configFile : files) {
            String absolutePath = configFile.getAbsolutePath();
            this.readJson(isClient, configFile);
        }
    }

    public void createDefaultEventConfigs() {
        for (Map.Entry<class_2960, LunarEvent> entry : EnhancedCelestialsRegistry.DEFAULT_EVENTS.entrySet()) {
            class_2960 location = entry.getKey();
            LunarEvent event = entry.getValue();
            Optional optionalKey = EnhancedCelestialsRegistry.LUNAR_EVENT.method_29113(event.codec());
            if (optionalKey.isPresent()) {
                this.createJsonEventConfig(event, location.toString());
                continue;
            }
            throw new IllegalStateException("Lunar Event Key for codec not there when requested: " + event.getClass().getSimpleName());
        }
    }

    public void addSettingsIfMissing() {
        for (Map.Entry<String, LunarEvent> entry : this.lunarEvents.entrySet()) {
            LunarEvent event = entry.getValue();
            String key = entry.getKey();
            File tomlFile = this.lunarEventsConfigPath.resolve(key + ".toml").toFile();
            File jsonFile = this.lunarEventsConfigPath.resolve(key + ".json").toFile();
            Optional optionalKey = EnhancedCelestialsRegistry.LUNAR_EVENT.method_29113(event.codec());
            if (optionalKey.isPresent()) {
                if (tomlFile.exists() || jsonFile.exists()) continue;
                this.createJsonEventConfig(event, key);
                continue;
            }
            throw new IllegalStateException("Lunar Event Key for codec not there when requested: " + event.getClass().getSimpleName());
        }
    }

    private void createJsonEventConfig(LunarEvent lunarEvent, String lunarEventID) {
        Path configFile = this.lunarEventsConfigPath.resolve(lunarEventID.replace(":", "-") + ".json");
        JsonElement jsonElement = (JsonElement)LunarEvent.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)lunarEvent).result().get();
        try {
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            Files.write(configFile, new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(jsonElement).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            EnhancedCelestials.LOGGER.error(e.toString());
        }
    }

    private void readJson(boolean isClient, File configFile) {
        try {
            String noTypeFileName = configFile.getName().replace(".json", "");
            String name = noTypeFileName.toLowerCase();
            LunarEvent decodedValue = ((LunarEvent)((Pair)LunarEvent.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse((Reader)new FileReader(configFile))).resultOrPartial(arg_0 -> ((Logger)EnhancedCelestials.LOGGER).error(arg_0)).get()).getFirst()).setKey(name);
            this.createJsonEventConfig(decodedValue, noTypeFileName);
            if (isClient) {
                if (this.lunarEvents.containsKey(name)) {
                    LunarEvent lunarEvent = this.lunarEvents.get(name);
                    lunarEvent.setClientSettings(decodedValue.getClientSettings());
                    lunarEvent.setLunarEventClient(lunarEvent.getClientSettings().createClient(), configFile.getAbsolutePath());
                }
            } else {
                this.lunarEvents.put(name, decodedValue);
            }
        }
        catch (FileNotFoundException e) {
            EnhancedCelestials.LOGGER.error(e.toString());
        }
    }

    private static LunarTimeSettings readOrCreateConfigJson(File configFile) {
        if (!configFile.exists()) {
            try {
                Path path = configFile.toPath();
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                JsonElement jsonElement = (JsonElement)LunarTimeSettings.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)LunarTimeSettings.DEFAULT).result().get();
                Files.write(path, new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create().toJson(jsonElement).getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return (LunarTimeSettings)((Pair)LunarTimeSettings.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse((Reader)new FileReader(configFile))).result().orElseThrow(RuntimeException::new)).getFirst();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public LunarForecast getLunarForecast() {
        return this.lunarForecast;
    }

    public Map<String, LunarEvent> getLunarEvents() {
        return this.lunarEvents;
    }

    public LunarTimeSettings getLunarTimeSettings() {
        return this.lunarTimeSettings;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float strength) {
        this.strength = strength;
    }

    public void setLastEvent(LunarEvent lastEvent) {
        this.lastEvent = lastEvent;
    }

    public void setCurrentEvent(String currentEvent) {
        this.currentEvent = currentEvent.equals(DEFAULT.getKey()) ? DEFAULT : this.lunarEvents.get(currentEvent);
    }

    public static class LunarTimeSettings {
        public static final Codec<LunarTimeSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.LONG.fieldOf("daylength").forGetter(lunarTimeSettings -> lunarTimeSettings.dayLength), (App)Codec.LONG.fieldOf("yearLengthInDays").forGetter(lunarTimeSettings -> lunarTimeSettings.yearLength), (App)Codec.LONG.fieldOf("minDaysBetweenLunarEvents").forGetter(lunarTimeSettings -> lunarTimeSettings.minDaysBetweenLunarEvents)).apply((Applicative)builder, LunarTimeSettings::new));
        public static final LunarTimeSettings DEFAULT = new LunarTimeSettings(24000L, 100L, 5L);
        private final long dayLength;
        private final long yearLength;
        private final long minDaysBetweenLunarEvents;

        public LunarTimeSettings(long dayLength, long yearLength, long minDaysBetweenLunarEvents) {
            this.dayLength = dayLength;
            this.yearLength = yearLength;
            this.minDaysBetweenLunarEvents = minDaysBetweenLunarEvents;
        }

        public long getDayLength() {
            return this.dayLength;
        }

        public long getYearLength() {
            return this.yearLength;
        }

        public long getMinDaysBetweenLunarEvents() {
            return this.minDaysBetweenLunarEvents;
        }
    }
}

